//
//  TSPLPrinterVC.m
//  PrinterDemo
//
//  Created by Apple Mac mini intel on 2024/4/20.
//

#import "TSPLPrinterVC.h"
#import "UIView+Toast.h"
#import "XSDKPrinter.h"

@interface TSPLPrinterVC ()<XBLEManagerDelegate, XWIFIManagerDelegate>
// bluetooth manager
@property (strong, nonatomic) XBLEManager *bleManager;
// wifi manager
@property (strong, nonatomic) XWIFIManager *wifiManager;

@property (weak, nonatomic) IBOutlet UISegmentedControl *cutterModeSegControl;
@property (assign, nonatomic) int cutter;
@end

@implementation TSPLPrinterVC

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"TSPL PRINT";
    self.cutter = 0;
    _bleManager = [XBLEManager sharedInstance];
    _bleManager.delegate = self;
    _wifiManager = [XWIFIManager sharedInstance];
    _wifiManager.delegate = self;
}

- (void)printWithData:(NSData *)dataM {
    
    if (_connectType == ConnectTypeBluetooth) {
        [_bleManager writeCommandWithData:dataM writeCallBack:^(CBCharacteristic *characteristic, NSError *error) {
            if (error) {
                NSLog(@"error:%@", error);
            } else {
                NSLog(@"write success");
            }
        }];
    } else if (_connectType == ConnectTypeWiFi) {
        [_wifiManager writeCommandWithData:dataM];
    } else {
        [self.view makeToast:@"printer no connect" duration:1.f position:CSToastPositionCenter];
    }
    
}

- (IBAction)selectCutterModeAction:(UISegmentedControl *)sender {
    if (sender.selectedSegmentIndex == 0) self.cutter = 0;
    if (sender.selectedSegmentIndex == 1) self.cutter = -1;
    if (sender.selectedSegmentIndex == 2) self.cutter = 1;
}

- (IBAction)setCutterAction:(id)sender {
    XTSPLCommand *command = [[XTSPLCommand alloc] init];
    [command setCutter:self.cutter];
    [self printWithData:[command getCommand]];
}

- (IBAction)cutPaperAction:(id)sender {
    XTSPLCommand *command = [[XTSPLCommand alloc] init];
    [command cut];
    [self printWithData:[command getCommand]];
}

- (IBAction)printTextAction:(id)sender {
    XTSPLCommand *command = [[XTSPLCommand alloc] init];
    [command sizeMm:70 height:85];
    [command gapMm:2 n:0];
    [command cls];
    [command textAtX:0 y:50 font:kFNT_8_12 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_8_12"];
    [command textAtX:0 y:100 font:kFNT_12_20 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_12_20"];
    [command textAtX:0 y:150 font:kFNT_16_24 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_16_24"];
    [command textAtX:0 y:200 font:kFNT_24_32 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_24_32"];
    [command textAtX:0 y:250 font:kFNT_32_48 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_32_48"];
    [command textAtX:0 y:300 font:kFNT_14_19 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_14_19"];
    [command textAtX:0 y:350 font:kFNT_14_25 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_14_25"];
    [command textAtX:0 y:400 font:kFNT_21_27 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_21_27"];
    
    /// TODO: Please confirm whether the printer has built-in simplified Chinese/traditional Chinese/Korean fonts
//    [command textAtX:0 y:450 font:kFNT_SIMPLIFIED_CHINESE rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_SIMPLIFIED_CHINESE"];
//    [command textAtX:0 y:500 font:kFNT_TRADITIONAL_CHINESE rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_TRADITIONAL_CHINESE"];
//    [command textAtX:0 y:550 font:kFNT_KOREAN rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"kFNT_KOREAN"];
    [command print];
    
    [self printWithData:[command getCommand]];
}

- (IBAction)printBarcodeAction:(id)sender {
    XTSPLCommand *command = [[XTSPLCommand alloc] init];
    [command sizeMm:70 height:85];
    [command gapMm:2 n:0];
    [command cls];
    
    [command barcodeAtX:0 y:100 codeType:kBarcodeTypeCode128 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:100 codeType:kBarcodeTypeCode128Manual height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:200 codeType:kBarcodeTypeEAN128 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:200 codeType:kBarcodeTypeInterleaved25 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:300 codeType:kBarcodeTypeInterleaved25C height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:300 codeType:kBarcodeTypeCode39 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:400 codeType:kBarcodeTypeCode39C height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:400 codeType:kBarcodeTypeCode93 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:500 codeType:kBarcodeTypeEAN13 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:500 codeType:kBarcodeTypeEAN13_2 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:600 codeType:kBarcodeTypeEAN13_5 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:600 codeType:kBarcodeTypeEAN8 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:700 codeType:kBarcodeTypeEAN8_2 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:700 codeType:kBarcodeTypeEAN8_5 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:800 codeType:kBarcodeTypeCodabar height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:800 codeType:kBarcodeTypePostnet height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:900 codeType:kBarcodeTypeUPCA height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:900 codeType:kBarcodeTypeUPCA_2 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:1000 codeType:kBarcodeTypeUPCA_5 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:1000 codeType:kBarcodeTypeUPCE height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:1100 codeType:kBarcodeTypeUPCE_2 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:1100 codeType:kBarcodeTypeUPCE_5 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:1200 codeType:kBarcodeTypeCpost height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:1200 codeType:kBarcodeTypeMSI height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:1300 codeType:kBarcodeTypeMSIC height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:1300 codeType:kBarcodeTypePlessey height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:1400 codeType:kBarcodeTypeITF14 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:1400 codeType:kBarcodeTypeEAN14 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:1500 codeType:kBarcodeTypeCode11 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:1500 codeType:kBarcodeTypeTelepen height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:1600 codeType:kBarcodeTypeTelepenN height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:1600 codeType:kBarcodeTypePlanet height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:1700 codeType:kBarcodeTypeCode49 height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:100 y:1700 codeType:kBarcodeTypeDPIIdentcode height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    [command barcodeAtX:0 y:1800 codeType:kBarcodeTypeDPILeitcode height:80 readable:ReadableTypeCenter andRotation:TSPLRotation0 narrow:2 wide:2 content:@"12345678"];
    
    [command print];
    [self printWithData:[command getCommand]];
}

- (IBAction)printQrcodeAction:(id)sender {
    XTSPLCommand *command = [[XTSPLCommand alloc] init];
    [command sizeMm:70 height:85];
    [command gapMm:2 n:0];
    [command cls];
    [command textAtX:10 y:0 font:kFNT_12_20 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"QRCode"];
    [command qrCodeAtX:200 andY:10 ecLevel:kECLevelM cellWidth:8 mode:kQRCodeModeAuto rotation:TSPLRotation0 content:@"www.google.com"];
    [command textAtX:10 y:200 font:kFNT_12_20 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"PDF417"];
    [command pdf417AtX:200 y:200 width:80 height:80 rotate:TSPLRotation0 content:@"PDF417"];
    [command textAtX:10 y:300 font:kFNT_12_20 rotation:TSPLRotation0 xRatio:1 yRatio:1 content:@"DataMatrix"];
    [command dataMatrixAtX:200 andY:300 width:80 height:80 content:@"DataMatrix"];
    [command print];
    [self printWithData:[command getCommand]];
}


- (IBAction)printImageAction:(id)sender {
    UIImage *image = [UIImage imageNamed:@"nv_test"];
    XTSPLCommand *command = [[XTSPLCommand alloc] init];
    [command sizeMm:70 height:85];
    [command gapMm:2 n:0];
    [command cls];
    [command bitmapAtX:0 y:0 mode:BMPModeOverwrite image:image];
    [command print];
    [self printWithData:[command getCommand]];
}

- (IBAction)printerStatusAction:(id)sender {
    
    if (_connectType == ConnectTypeBluetooth) {
        [_bleManager printerLabelStatus:^(NSData *status) {
            [self toastWith:status];
        }];
    } else if (_connectType == ConnectTypeWiFi) {
        [_wifiManager printerLabelStatus:^(NSData *status) {
            [self toastWith:status];
        }];
    }
}

- (void)toastWith:(NSData *)data {

    unsigned status = 0;
    if (data.length == 1) {
        const Byte *byte = (Byte *)[data bytes];
        status = byte[0];
    } else if (data.length == 2) {
        const Byte *byte = (Byte *)[data bytes];
        status = byte[1];
    }
    
    if (status == 0x00) {
        [self.view makeToast:@"Ready" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x01) {
        [self.view makeToast:@"Cover opened" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x02) {
        [self.view makeToast:@"Paper jam" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x03) {
        [self.view makeToast:@"Cover opened and paper jam" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x04) {
        [self.view makeToast:@"Paper end" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x05) {
        [self.view makeToast:@"Cover opened and Paper end" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x08) {
        [self.view makeToast:@"No Ribbon" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x09) {
        [self.view makeToast:@"Cover opened and no Ribbon" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x10) {
        [self.view makeToast:@"Pause" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x20) {
        [self.view makeToast:@"Printing.." duration:1.f position:CSToastPositionCenter];
    }
}

#pragma mark - XBLEManagerDelegate


- (void)xbleDisconnectPeripheral:(CBPeripheral *)peripheral error:(NSError *)error {
    [self.view makeToast:@"disconnect.." duration:1.f position:CSToastPositionCenter];
    [self.navigationController popViewControllerAnimated:YES];
}

#pragma mark - XWIFIManagerDelegate

- (void)xWifiDisconnectWithError:(NSError *)error {
    [self.view makeToast:@"disconnect.." duration:1.f position:CSToastPositionCenter];
    [self.navigationController popViewControllerAnimated:YES];
}

@end
